/*
 * Copyright (C) Sergey Kolesov 2012-2021 <kolesov@ocean.phys.msu.ru>
 * See ffaultfdisp.cpp for licensing details
 */

#include <ctime>

#include "nc.h"
#include "config.h"

//===============================
void NetCDFInit(netCDF::NcFile& nc, unsigned Nlon, unsigned Nlat, float *lons, float *lats, float& time_step, string& event, string& eventtag)
{
 // global attributes
 nc.putAtt("source", PACKAGE_STRING);
 nc.putAtt("MAGIC", NETCDF_MAGIC);
 nc.putAtt("title", NETCDF_TITLE);
 nc.putAtt("event", event);
 nc.putAtt("eventtag", eventtag);
auto now = time(nullptr);
 nc.putAtt("created", asctime(localtime(&now)));

 // add dimensions
auto latDim = nc.addDim(LAT_NAME, Nlat);
auto lonDim = nc.addDim(LON_NAME, Nlon);
auto timeDim = nc.addDim(TIME_NAME);  // unlimited
 // add timestep
auto timestepVar = nc.addVar(TIMESTEP_NAME, netCDF::ncFloat);
 timestepVar.putVar(&time_step);
 timestepVar.putAtt("long_name", TIMESTEP_NAME_LONG);
 timestepVar.putAtt("units", TIMESTEP_UNITS); 
 // define the coordinate variables
auto latVar = nc.addVar(LAT_NAME, netCDF::ncFloat, latDim);
auto lonVar = nc.addVar(LON_NAME, netCDF::ncFloat, lonDim);
 latVar.putVar(lats);
 lonVar.putVar(lons);
 latVar.putAtt("units", LAT_UNITS);
 lonVar.putAtt("units", LON_UNITS);
 // add displacement vars
vector<netCDF::NcDim> dimVector;
 dimVector.push_back(timeDim);
 dimVector.push_back(latDim);
 dimVector.push_back(lonDim);
auto dispXVar = nc.addVar(DISPX_NAME, netCDF::ncFloat, dimVector);
auto dispYVar = nc.addVar(DISPY_NAME, netCDF::ncFloat, dimVector);
auto dispZVar = nc.addVar(DISPZ_NAME, netCDF::ncFloat, dimVector);
 dispXVar.putAtt("long_name", DISPX_NAME_LONG);
 dispXVar.putAtt("units", DISP_UNITS);
 dispXVar.putAtt("positive", "east");
 dispYVar.putAtt("long_name", DISPY_NAME_LONG);
 dispYVar.putAtt("units", DISP_UNITS);
 dispYVar.putAtt("positive", "north");
 dispZVar.putAtt("long_name", DISPZ_NAME_LONG);
 dispZVar.putAtt("units", DISP_UNITS);
 dispZVar.putAtt("positive", "up");
}
//===============================
void SaveTimeSlice(netCDF::NcFile& nc, unsigned idxSlice, unsigned Nlon, unsigned Nlat, double *dx, double *dy, double *dz)
{
auto dispXVar = nc.getVar(DISPX_NAME);
auto dispYVar = nc.getVar(DISPY_NAME);
auto dispZVar = nc.getVar(DISPZ_NAME);

vector<size_t> startp, countp;
 startp.push_back(idxSlice);
 startp.push_back(0);
 startp.push_back(0);
 countp.push_back(1);
 countp.push_back(Nlat);
 countp.push_back(Nlon);
 
 dispXVar.putVar(startp, countp, dx);
 dispYVar.putVar(startp, countp, dy);
 dispZVar.putVar(startp, countp, dz);
}
//===============================