/*
 * Copyright (C) Sergey Kolesov 2012-2021 <kolesov@ocean.phys.msu.ru>
 * See ffaultfdisp.cpp for licensing details
 */

#ifndef _NC_H_
#define _NC_H_

#include <netcdf>

using namespace std;

// NetCDF strings
const string 
 NETCDF_MAGIC = "FFDD",
 NETCDF_TITLE = "Pseudo-dynamic coseismic bottom deformation calculated using Okada formulae",
 LAT_NAME = "latitude",
 LON_NAME = "longitude",
 TIME_NAME = "time",
 TIMESTEP_NAME = "time_interval",
 TIMESTEP_NAME_LONG = "Time interval between snapshots",
 DISPX_NAME = "ew_disp",
 DISPX_NAME_LONG = "EW bottom displacement",
 DISPY_NAME = "ns_disp",
 DISPY_NAME_LONG = "NS bottom displacement",
 DISPZ_NAME = "z_disp",
 DISPZ_NAME_LONG = "Vertical bottom displacement",
 TIMESTEP_UNITS = "s",
 DISP_UNITS = "m",
 LAT_UNITS = "degrees_north",
 LON_UNITS = "degrees_east";

void NetCDFInit(netCDF::NcFile& nc, unsigned Nlon, unsigned Nlat, float *lons, float *lats, float& time_step, string& event, string& eventtag);
void SaveTimeSlice(netCDF::NcFile& nc, unsigned idxSlice, unsigned Nlon, unsigned Nlat, double *dx, double *dy, double *dz);

#endif