/*
 * Copyright (C) Sergey Kolesov 2012-2021 <kolesov@ocean.phys.msu.ru>
 * See ffaultfdisp.cpp for licensing details
 */

#ifndef _OKADA_H_
#define _OKADA_H_


//  Uncomment for Okada formulae testing
//#define TEST_OKADA


#include <cmath>

using namespace std;
//===============================
enum TFaultPosition { BottomLeft=0, Middle, BottomCenter, TopCenter };
//===============================
class TFault
{
 private:
    double Lat, Lon, Depth;
    double Slip, Rake, Strike, Dip;
    double L, W;
    double TRup, Rise;
    double cosDip, sinDip, cosRake, sinRake, cosStrike, sinStrike; // sin & cos of respective angles

    const double Chinnery(double (TFault::*F)(double, double, double), double x, double p, double q);

    double ux_ss(double xi, double eta, double q);
    double uy_ss(double xi, double eta, double q);
    double uz_ss(double xi, double eta, double q);
    double ux_ds(double xi, double eta, double q);
    double uy_ds(double xi, double eta, double q);
    double uz_ds(double xi, double eta, double q);

    double I1(double xi, double eta, double q, double R);
    double I2(double eta,  double q, double R);
    double I3(double eta, double q, double R);
    double I4(double d_, double eta, double q, double R);
    double I5(double xi, double eta, double q, double R, double d_);

 public:
    static TFaultPosition FaultPos;
    static double CR;
    unsigned id; // ident number, mostly for testing

    TFault() { Lat=Lon=Depth=Slip=Rake=Strike=Dip=L=W=TRup=Rise=0; }
    TFault(double lon, double lat, double depth, double slip, double rake, double strike, double dip, double l, double w, double trup=0, double rise=0);

    void CalcDisp(float lon, float lat, double& ue, double& un, double& uz, double slip_frac=1.);
    void CalcDisp(float time, float time_inc, float lon, float lat, double& ue, double& un, double& uz);
    void OkadaFormulae(double x, double y, double& ux, double& uy, double& uz, double slip_frac=1.);

    bool BeforeRupture(float time) { return time < TRup ? true : false; }
    bool AfterRupture(float time) { return time > TRup+Rise ? true : false; }
};
//===============================

const double RE = 6371007., // Radius [m] of our mother-planet
 deg2rad = M_PI/180;
double SphericalDist(double Lon1, double Lat1, double Lon2, double Lat2);

#ifdef TEST_OKADA
void TestOkada(void);
#endif

#endif