/*
 * Copyright (C) Sergey Kolesov 2012-2021 <kolesov@ocean.phys.msu.ru>
 * See ffaultfdisp.cpp for licensing details
 */

#ifndef _SOLVER_H_
#define _SOLVER_H_

#include <netcdf>

#include "okada.h"

using namespace std;
//===============================
void ParseFiniteFault(istream& Is);
void FspFormat(istream& Is, int& ln);
void FspGetPair(string line, double& a, double& b);
void OwnFormat(istream& Is, int& ln);
void CreateFault(string &Str, double l=0, double w=0, double strk=0, double dip=0);

void SetRes2Cout(bool O_RLY);
double LonTo360(double l);
void SetGridBounds(char* Str);
void SetGridInterval(char* Str);
void SetFaultPosition(char* Str);
void SetCR(char* Str);
void SetDynamicMode(char *Str);
void SetPrecision(char* Str);

void StaticGrid(void);
void SaveGrid(ostream& Os);
void ParseSet(istream& Is);
void StaticSet(void);
void SaveSet(ostream& Os);
void DynamicGrid(netCDF::NcFile& nc);

#endif
